% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{fixErrors.SpatialPolygons}
\alias{fixErrors.SpatialPolygons}
\title{Fix \code{rgeos::gIsValid} failures in \code{SpatialPolygons}}
\usage{
\method{fixErrors}{SpatialPolygons}(x, objectName = NULL,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE), ...)
}
\arguments{
\item{x}{A \code{SpatialPolygons} object}

\item{objectName}{Optional. This is only for messaging; if provided, then messages relayed
to user will mention this.}

\item{attemptErrorFixes}{Will attempt to fix known errors. Currently only some failures
for SpatialPolygons* are attempted. Notably with \code{raster::buffer(..., width = 0)}.
Default \code{TRUE}, though this may not be the right action for all cases.}

\item{useCache}{Logical, default \code{getOption("reproducible.useCache", FALSE)}, whether
Cache is used on the internal \code{raster::buffer} command.}

\item{...}{Passed to methods. None currently implemented.}
}
\description{
This uses \code{raster::buffer(..., width = 0)} internally, which fixes some
failures to \code{rgeos::gIsValid}
}
