% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calcEffectSizeConfidenceIntervals}
\alias{calcEffectSizeConfidenceIntervals}
\title{calcEffectSizeConfidenceIntervals}
\usage{
calcEffectSizeConfidenceIntervals(
  effectsize,
  effectsize.variance,
  effectsize.df = 0,
  alpha = 0.05,
  alternative = "two.sided",
  UpperValue = Inf,
  LowerValue = -Inf
)
}
\arguments{
\item{effectsize}{The effect size}

\item{effectsize.variance}{The effect size variance}

\item{effectsize.df}{The degrees of freedome for confidence intervals based on the t- distribution. If df=0 (default), the confidence interval is based on the normal distribution}

\item{alpha}{The significance level of the confidence interval
(default 0.05).}

\item{alternative}{This defines whether a one-sided test or a two-sided
(default) test is required. For a one-sided test use parameter values
greater' or 'less' to define whether the d-value should be greater or less
than zero.}

\item{UpperValue}{The maximum legal value of the effect size (default Inf).
Used to ensure that confidence intervals of effect sizes such as correlation
coefficients are restricted to sensible values.}

\item{LowerValue}{The minimum legal value of the effect size (default -Inf).
Used to ensure that confidence intervals of effect sizes
such as correlation coefficients are restricted to sensible values}
}
\value{
The value of the test statistic, the p.value of test statistic, the upper and lower confidence interval of the effect size, a logical value specifying whether the effect size is significantly different from zero based on the confidence interval and the lower and upper confidence interval bounds.
}
\description{
This function provides single-sided and two-sided confidence interval of an effect size (assuming that the null hypothesis value is zero).
}
\examples{
reproducer:::calcEffectSizeConfidenceIntervals(
  effectsize=0.37,effectsize.variance=0.00847,effectsize.df=11.1,
  alpha=0.05,alternative='two.sided',UpperValue=0.5,LowerValue=-0.5)
# A tibble: 1 x 5
#  ES.test ES.pvalue ES.sig ES.ci.lower ES.ci.upper
#    <dbl>     <dbl> <lgl>        <dbl>       <dbl>
#1    4.02   0.00198 TRUE         0.168         0.5
}
\author{
Barbara Kitchenham and Lech Madeyski
}
