% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{simulate4GExperimentData}
\alias{simulate4GExperimentData}
\title{simulate4GExperimentData}
\usage{
simulate4GExperimentData(
  mean,
  sd,
  diff,
  GroupSize,
  type = "n",
  ExpAdj = 0,
  StdAdj = 0,
  BlockEffect = 0,
  BlockStdAdj = 0
)
}
\arguments{
\item{mean}{The mean (or rate for gamma data) of the baseline distribution}

\item{sd}{The standard deviation (or shape for gamma data) of the baseline distribution}

\item{diff}{The adjustment to the baseline mean for the alternative distribution.}

\item{GroupSize}{An integer defining the number of data items in each group.}

\item{type}{A string dentifying the distrubtion used to simulate the data: 'n' for normal, 'l' for log-normal, 'g' for gamma, 'lap' for Laplace.}

\item{ExpAdj}{An additional adjument factor that is added to both the mean values. Defaults to zero.}

\item{StdAdj}{An aditional adjustment factor that is added to the second group variance (or rate for gamma data). Defaults to zero.}

\item{BlockEffect}{An additional factor that is added to the mean of the second group groups (shape for the gamma distribution). Defaults to zero.}

\item{BlockStdAdj}{An additional factor that is added to the variance of the second group (shape for the gamma distribution). Defaults to zero.}
}
\value{
A table with four columns (BaselineData.B1, AlternativeData.B1,BaselineData.B2, AlternativeData.B2,) holding the data for each group and block. For lognormal data an additional four columns are added which return the log transformed data for each group.
}
\description{
The function returns a four group data set based on one of four different distributions.
}
\examples{
set.seed(246)
simulate4GExperimentData(mean = 0, sd = 1, diff = 0.5, GroupSize = 5,
  type = "n", ExpAdj = 0, StdAdj = 0, BlockEffect = 0.5, BlockStdAdj = 0)
# A tibble: 5 x 4
#  BaselineData.B1 AlternativeData.B1 BaselineData.B2 AlternativeData.B2
#            <dbl>              <dbl>           <dbl>              <dbl>
# 1          0.533               1.84            0.749              3.98
# 2          0.251               2.03            1.56               1.09
# 3         -0.290               0.929           0.213              3.94
# 4         -1.48                1.17            1.13               0.106
# 5          0.0340              0.895           0.399              0.879
as.data.frame(
  simulate4GExperimentData(
    mean=0, sd=1, diff=0.5, GroupSize=5, type='l', ExpAdj=0, StdAdj=0,
    BlockEffect = 0.5, BlockStdAdj = 0))
#  BaselineData.B1 AlternativeData.B1 transBaselineData.B1 transAlternativeData.B1
#1       1.4019869           1.049158            0.3378905               0.0479875
#2       3.8514120           0.769227            1.3484398              -0.2623692
#3       6.5162726           1.574126            1.8743025               0.4537002
#4       1.3309218           1.082774            0.2858718               0.0795259
#5       0.2772234           1.630194           -1.2829316               0.4886992
#  BaselineData.B2 AlternativeData.B2 transBaselineData.B2 transAlternativeData.B2
#1       5.4656049          4.6095688            1.6984748               1.5281343
#2       1.6149559          2.0244244            0.4793077               0.7052854
#3       1.7718620          0.5504016            0.5720310              -0.5971070
#4       0.6774067          1.5434812           -0.3894834               0.4340404
#5       0.4507284          5.4987830           -0.7968903               1.7045268
}
\author{
Barbara Kitchenham and Lech Madeyski
}
