% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MadeyskiKitchenhamMetaAnalysis.R
\name{getEffectSizesABBA}
\alias{getEffectSizesABBA}
\title{getEffectSizesABBA}
\usage{
getEffectSizesABBA(simulationData)
}
\arguments{
\item{simulationData}{- data set in a form required to calculate effect sizes in AB/BA crossover experimental designs}
}
\value{
data frame incl. calculated effect sizes and variances:
# dIG - independent groups standardized effect size
# var.dIG - variance of independent groups standardized effect size
# dRM - repeated measures (within-subjects) standardized effect size
# var.dRM - variance of repeated measures (within-subjects) standardized effect size
# dIG.Fromt - independent groups standardized effect size calculated from t: dIG.Fromt=t*sqrt(1-r)*sqrt((N1+N2)/(2*N1*N2))
# var.dIG.Fromt - variance of independent groups standardized effect size calculated from t: var.dIG.Fromt=var.t*(1-r)*((N1+N2)/(2*N1*N2))
# dRM.Fromt - dRM calculated from t: dRM.Fromt=t*sqrt((N1+N2)/(2*N1*N2))
# var.dRM.Fromt - var.dRM calculated from t: var.dRM.Fromt = var.t*((N1+N2)/(2*N1*N2))
# var.dRM.Fromt2 - var.dRM calculated from t or rather dRM.Fromt: var.dRM.Fromt2=(df/(df-2))*((N1+N2)/(2*N1*N2)+dRM.Fromt^2)- dRM.Fromt^2/c^2
# var.dRM.Approx - var.dRM calculated on a basis of Johnson and Welch (1940) report an approximate formulate for the variance of a t variable: var.dRM.Approx=((N1+N2)/(2*N1*N2)) + (dRM^2)/(2*(N1+N2-2)) #see paper and Equation 49
# var.dIG.Approx - var.dIG calculated on a basis of Johnson and Welch (1940) report an approximate formulate for the variance of a t variable: var.dIG.Approx=(((N1+N2)*(1-r))/(2*N1*N2)) + (dIG^2)/(2*(N1+N2-2)) #see paper and Equation 50
# unstandardizedES - estimated unstandardized technique effect size
# periodES - estimated period effect
# var.sig - sum of within-subjects variance and between-subjects variance
# var.within - within-subjects variance
# var.between - between-subjects variance
# t - t-value
# var.t - variance of t-variable
# gRM - Hedges and Olkin (1985) unbiased estimator of the repeated measures effect size gRM=dRM*c
# var.gRM - variance of gRM calculated as follows: var.gRM=(df/(df-2))*(((N1+N2)/(2*N1*N2))*c^2+gRM^2)- gRM^2/c^2 #Equation 56
# var.gRM2 - variance of gRM calculated as follows: var.gRM2=var.dRM*c^2
# gIG - Hedges and Olkin (1985) unbiased estimator of the independent groups effect size gIG=dIG*c
# var.gIG - variance of gIG calculated as follows: var.gIG=(df/(df-2))*(((N1+N2)/(2*N1*N2))*c^2+gIG^2)- gIG^2/c^2 #Equation 57
# var.gIG2 - variance of gRM calculated as follows: var.gIG2=var.dIG*c^2
# r - the correlation between the values observed for the same subject
}
\description{
Function to calculate both effect sizes (dIG, dRM), i.e., independent groups and repeated measures standardized effect sizes and variances, for AB/BA crossover design studies. Function is used in a paper "Effect Sizes and their Variance for AB/BA Crossover Design Studies" by Lech Madeyski and Barbara Kitchenham.
}
\examples{
simulationData<-getSimulationData(25, 18.75, 50, 10, 5, 500) #generate simulated data set
es<-getEffectSizesABBA(simulationData) #return effect sizes and variances
#OR
simulationData<-getSimulationData(25, 18.75,50,10,5,15)
es<-getEffectSizesABBA(simulationData) #return effect sizes and variances
}
\author{
Lech Madeyski and Barbara Kitchenham
}
