% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr_matrix_df.r
\name{repr_*.matrix/data.frame}
\alias{repr_*.matrix/data.frame}
\alias{repr_html.matrix}
\alias{repr_html.data.frame}
\alias{repr_latex.matrix}
\alias{repr_latex.data.frame}
\alias{repr_markdown.matrix}
\alias{repr_markdown.data.frame}
\alias{repr_text.matrix}
\alias{repr_text.data.frame}
\title{Tabular data representations}
\usage{
\method{repr_html}{matrix}(obj, ...)

\method{repr_html}{data.frame}(obj, ...)

\method{repr_latex}{matrix}(obj, ...,
  colspec = getOption("repr.matrix.latex.colspec"))

\method{repr_latex}{data.frame}(obj, ...,
  colspec = getOption("repr.matrix.latex.colspec"))

\method{repr_markdown}{matrix}(obj, ...)

\method{repr_markdown}{data.frame}(obj, ...)

\method{repr_text}{matrix}(obj, ...)

\method{repr_text}{data.frame}(obj, ...)
}
\arguments{
\item{obj}{The matrix or data.frame to create a representation for}

\item{...}{ignored}

\item{colspec}{The colspec for the LaTeX table. The default is given by the option \code{repr.matrix.latex.colspec}}
}
\description{
HTML, LaTeX, and Markdown representations of Matrix-like objects
}
\seealso{
\link{repr-options} for \code{repr.matrix.latex.colspec}
}
