\name{uvsum}
\alias{uvsum}
\title{Get univariate summary dataframe}
\usage{
  uvsum(response, covs, data, type = NULL, strata = 1,
    markup = T, sanitize = T, nicenames = T, testing = F)
}
\arguments{
  \item{response}{string vector with name of response}

  \item{covs}{character vector with the names of columns to
  fit univariate models to}

  \item{data}{dataframe containing data}

  \item{type}{string indicating he type of univariate model
  to fit. The function will try and guess what type you
  want based on your response. If you want to override this
  you can manually specify the type. Options in clude
  "linear", "logistic", "coxph", "crr",
  "boxcox","logistic"}

  \item{strata}{character vector of covariates to stratify
  by. Only used for coxph and crr}

  \item{markup}{boolean indicating if you want latex
  markup}

  \item{sanitize}{boolean indicating if you want to
  sanitize all strings to not break LaTeX}

  \item{nicenames}{booling indicating if you want to
  replace . and _ in strings with a space}

  \item{testing}{boolean to indicate if you want to print
  out the covariates before the model fits. This will allow
  you to see which model is not fitting if the function
  throws an error}
}
\description{
  Returns a dataframe corresponding to a univariate table
}
\keyword{dataframe}

