% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_get}
\alias{repo_get}
\title{Retrieve an item from the repo.}
\usage{
repo_get(name, enableSuggestions = T)
}
\arguments{
\item{name}{An item's name.}

\item{enableSuggestions}{If set to TRUE (default), enables some
checks on \code{name} that are meant to gracefully handle
errors and provide suggestions of similar names. If FALSE, the
execution will be significantly faster in large repositories.}
}
\value{
The previously stored object, or its file system path for
    attachments.
}
\description{
Retrieve an item from the repo.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", "get")
print(rp$get("item1"))

## wiping temporary repo
unlink(rp_path, TRUE)
}
