% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_copy}
\alias{repo_copy}
\title{Copy items to another repo}
\usage{
repo_copy(repo, destrepo, name, tags = NULL)
}
\arguments{
\item{repo}{An object of class repo (will copy from it)}

\item{destrepo}{An object of class repo (will copy to it)}

\item{name}{The name of the object to copy}

\item{tags}{If not NULL, copy all items matching tags.}
}
\value{
Used for side effects.
}
\description{
Copies an obj file from one repo to another and creates a new entry
in the index of the destination repository. Supports tags.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo1")
repo1 <- repo_open(repo_path, TRUE)
repo1$put(0, "item1", "A sample item", "tag1", replace=TRUE)
repo_path2 <- file.path(tempdir(), "example_repo2")
repo2 <- repo_open(repo_path2, TRUE)
repo1$copy(repo2, "item1")

## wiping temporary repo
unlink(repo_path, TRUE)
}

