% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{replicationInterval-package}
\alias{replicationInterval}
\alias{replicationInterval-package}
\title{Replication Interval}
\description{
A common problem faced by journal reviewers and authors is the question of
whether the results of a replication study are consistent with the original
published study. One solution to this problem is to examine the effect size
from the published study and generate the range of effect sizes that could
reasonably be obtained (due to random sampling) in a replication attempt
(i.e., calculate a replication interval). If a replication effect size falls
outside the replication interval then that value could not have occurred to
due the effects of sampling error alone. Alternatively, if a replication
effect size falls within the replication interval then the replication
results could have reasonably occurred due to the effects of sampling error
alone. This package calculates the replication interval for two different types of effect sizes (i.e., correlation, Cohen's \emph{d} ).
\tabular{ll}{
Package: \tab replicationInterval\cr
Type: \tab Package\cr
Version: \tab 0.1\cr
Date: \tab 2014-07-19\cr
License: \tab Unlimited\cr
}
\code{\link{ri.d}} creates a replication interval for a Cohen's \emph{d} \cr
\code{\link{ri.r}} creates a replication interval for a correlation\cr
}
\examples{
ri.d(d=.65,n1=20,n2=20)
ri.d(d=.65,n1=20,n2=20,explain=TRUE)
ri.r(r=.35,n=40)
ri.r(r=.35,n=40,explain=TRUE)
}
\author{
\tabular{ll}{
Author: \tab David J. Stanley \email{dstanley@uoguelph.ca}\cr
Maintainer: \tab David J. Stanley \email{dstanley@uoguelph.ca}
}
}
\references{
Spence, J.R., & Stanley, D.J.(2014). Replication Interval: What to expect when you're expecting ... a replication. [manuscript in preparation] \cr\cr
Stanley, D.J., & Spence, J.R.(2014). Expectations for replications: Are yours realistic? \emph{Perspectives on Psychological Science, 9}, 305-318.
}
\keyword{package}

