% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Status}
\usage{
status(project = NULL, ..., library = NULL, lockfile = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Optional arguments; reserved for future expansion.}

\item{library}{The path to a library. By default, the project library
associated with the requested project \code{project} is used.}

\item{lockfile}{The path to a lockfile. By default, the project lockfile
(called \code{renv.lock}) is used.}
}
\value{
This function is normally called for its side effects.
}
\description{
Report differences between the project's lockfile and the current state of
the private library (if any).
}
\examples{
\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
