% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install Packages}
\usage{
install(
  packages = NULL,
  ...,
  library = NULL,
  type = NULL,
  rebuild = FALSE,
  repos = NULL,
  prompt = interactive(),
  project = NULL
)
}
\arguments{
\item{packages}{A character vector of \R packages to install. Required
package dependencies (\code{Depends}, \code{Imports}, \code{LinkingTo}) will be installed
as required.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{type}{The type of package to install ("source" or "binary"). Defaults
to the value of \code{getOption("pkgType")}.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{repos}{The repositories to use during restore, for packages installed
from CRAN or another similar R package repository. When set, this will
override any repositories declared in the lockfile. See also the
\code{repos.override} option in \link{config} for an alternate way to provide a
repository override.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Install one or more \R packages, from a variety of remote sources.
}
\details{
\code{install()} uses the same machinery as \code{\link[=restore]{restore()}} when installing packages.
In particular, this means that the local cache of package installations is
used when possible. This helps to avoid re-downloading packages that have
already been downloaded before, and re-compiling packages from source when
a binary copy of that package is already available.
}
\section{Project DESCRIPTION Files}{


If your project contains a \code{DESCRIPTION} file, then calling \code{install()}
without any arguments will instruct \code{renv} to install the latest versions of
all packages as declared within that \code{DESCRIPTION} file's \code{Depends},
\code{Imports} and \code{LinkingTo} fields; similar to how an \R package might declare
its dependencies.

If you have one or more packages that you'd like to install from a separate
remote source, this can be accomplished by adding a \verb{Remotes:} field to the
\code{DESCRIPTION} file. See \code{vignette("dependencies", package = "devtools")}
for more details. Alternatively, view the vignette online at
\url{https://devtools.r-lib.org/articles/dependencies.html}.

Note that \code{install()} does not use the project's \code{renv.lock} when determining
sources for packages to be installed. If you want to install packages using
the sources declared in the lockfile, consider using \code{restore()} instead.
Otherwise, you can declare the package sources in your \code{DESCRIPTION}'s
\verb{Remotes:} field.
}

\section{Remotes Syntax}{


\code{renv} supports a subset of the \code{remotes} syntax used for package installation,
as described in \url{https://remotes.r-lib.org/articles/dependencies.html}. See
the examples below for more details.
}

\section{Bioconductor}{


Packages from Bioconductor can be installed by using the \verb{bioc::} prefix.
For example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv::install("bioc::Biobase")
}\if{html}{\out{</div>}}

will install the latest-available version of \code{Biobase} from Bioconductor.

\code{renv} depends on \code{BiocManager} (or, for older versions of \R, \code{BiocInstaller})
for the installation of packages from Bioconductor. If these packages are
not available, \code{renv} will attempt to automatically install them before
fulfilling the installation request.
}

\section{Package Configuration}{


Many \R packages have a \code{configure} script that needs to be run to prepare
the package for installation. Arguments and environment variables can be
passed through to those scripts in a manner similar to \link{install.packages}.
In particular, the \R options \code{configure.args} and \code{configure.vars} can be
used to map package names to their appropriate configuration. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# installation of RNetCDF may require us to set include paths for netcdf
configure.args = c(RNetCDF = "--with-netcdf-include=/usr/include/udunits2"))
options(configure.args = configure.args)
renv::install("RNetCDF")
}\if{html}{\out{</div>}}

This could also be specified as, for example,

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(
  configure.args.RNetCDF = "--with-netcdf-include=/usr/include/udunits2"
)
renv::install("RNetCDF")
}\if{html}{\out{</div>}}

Similarly, additional flags that should be passed to \verb{R CMD INSTALL} can
be set via the \code{install.opts} \R option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# installation of R packages using the Windows Subsystem for Linux
# may require the `--no-lock` flag to be set during install
options(install.opts = "--no-lock")
renv::install("xml2")
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{

# install the latest version of 'digest'
renv::install("digest")

# install an old version of 'digest' (using archives)
renv::install("digest@0.6.18")

# install 'digest' from GitHub (latest dev. version)
renv::install("eddelbuettel/digest")

# install a package from GitHub, using specific commit
renv::install("eddelbuettel/digest@df55b00bff33e945246eff2586717452e635032f")

# install a package from Bioconductor
# (note: requires the BiocManager package)
renv::install("bioc::Biobase")

# install a package, specifying path explicitly
renv::install("~/path/to/package")

# install packages as declared in the project DESCRIPTION file
renv::install()

}
}
