% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\title{Update Packages}
\usage{
update(
  packages = NULL,
  ...,
  exclude = NULL,
  library = NULL,
  rebuild = FALSE,
  check = FALSE,
  prompt = interactive(),
  project = NULL
)
}
\arguments{
\item{packages}{A character vector of \R packages to update. When \code{NULL}
(the default), all packages will be updated.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{exclude}{A set of packages to explicitly exclude from updating.
Use \verb{renv::update(exclude = <...>)} to update all packages except for
a specific set of excluded packages.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{check}{Boolean; check for package updates without actually
installing available updates? This is useful when you'd like to determine
what updates are available, without actually installing those updates.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Update packages which are currently out-of-date. Currently, only
CRAN and GitHub package sources are supported.
}
\details{
Updates will only be checked from the same source -- for example,
if a package was installed from GitHub, but a newer version is
available on CRAN, that updated version will not be seen.

You can call \code{renv::update()} with no arguments to update all packages within
the project, excluding any packages ignored via the \code{ignored.packages}
project setting. Use the \code{exclude} argument to further refine the exclusion
criteria if desired.
}
\examples{
\dontrun{

# update the 'dplyr' package
renv::update("dplyr")

}
}
