% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{rrankSend}
\alias{rrankSend}
\alias{recencyRank}
\alias{rrank}
\title{rrankSend}
\usage{
rrankSend(consider_type = TRUE)
}
\arguments{
\item{consider_type}{logical, indicates whether to discriminate between
event types in determining the event rank (TRUE, default) or not (FALSE).}
}
\value{
List with all information required by `remstats::remstats()` to 
compute the statistic.
}
\description{
Specifies the statistic for a recency rank send effect in the
\code{effects} argument of \code{\link{tomstats}} or the
\code{receiver_effects} argument of \code{\link{aomstats}}.
}
\details{
The rrankSend effect refers to a rank-based recency effect, as described in
section 2.2.5 of Butts (2008). For each timepoint t, for directed dyad (i,j)
the statistic is equal to the inverse of the rank of receiver j among the
actors to which sender i has most recently send past events. Note that the
'rrankSend' effect is only defined for directed events.
}
\examples{
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ rrankSend()
remstats(tie_effects = effects, reh = reh_tie)

reh_actor <- remify::remify(history, model = "actor")
remstats(receiver_effects = effects, reh = reh_actor)

}
\seealso{
\code{\link{rrankReceive}}, \code{\link{recencySendSender}},
\code{\link{recencySendReceiver}}, \code{\link{recencyReceiveSender}},
\code{\link{recencyReceiveReceiver}} and \code{\link{recencyContinue}} for
other type of recency effects
}
