% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{rrankReceive}
\alias{rrankReceive}
\title{rrankReceive}
\usage{
rrankReceive(consider_type = TRUE)
}
\arguments{
\item{consider_type}{logical, indicates whether to discriminate between
event types in determining the event rank (TRUE, default) or not (FALSE).}
}
\value{
List with all information required by `remstats::remstats()` to 
compute the statistic.
}
\description{
Specifies the statistic for a recency rank receive effect in the
\code{effects} argument of \code{\link{tomstats}} or the
\code{receiver_effects} argument of \code{\link{aomstats}}.
}
\details{
The rrankSend effect refers to a rank-based recency effect, as described in
section 2.2.5 of Butts (2008). For each timepoint t, for directed dyad (i,j)
the statistic is equal to the inverse of the rank of receiver j among the
actors from which sender i has most recently received past events. Note that
the 'rrankReceive' effect is only defined for directed events.
}
\examples{

reh_tie <- remify::remify(history, model = "tie")
effects <- ~ rrankReceive()
remstats(reh = reh_tie, tie_effects = effects)

reh_actor <- remify::remify(history, model = "actor")
remstats(receiver_effects = effects, reh = reh_actor)

}
\seealso{
\code{\link{rrankSend}}, \code{\link{recencySendSender}},
\code{\link{recencySendReceiver}}, \code{\link{recencyReceiveSender}},
\code{\link{recencyReceiveReceiver}} and \code{\link{recencyContinue}} for
other type of recency effects
}
