% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{info}
\alias{info}
\title{Simulated exogenous information on actors in a social network.}
\format{
A dataframe with 10 rows and 5 variables:
\describe{
 \item{id}{numeric id of the actor}
 \item{time}{numeric value, describes when the value of the covariate 
  changes, if it changes}
 \item{age}{dichotomized age of the actor (e.g., 0 = below 25, 1 = 25 or 
  older)}
 \item{sex}{dichotomized sex of the actor (e.g., 0 = male, 1 = female)}
 \item{extraversion}{standardized extraversion score of the actor}
 \item{agreeableness}{standardized agreeableness score of the actor}
}
}
\source{
Simulated exogenous information on actors in a social network.
}
\usage{
data(info)
}
\description{
A dataset containing exogenous information on the actors in the social 
network of a relational event history. Data is simulated.
}
\examples{
data(info)

}
\seealso{
\code{\link{history}} for the relational event history.
}
\keyword{dataset}
