% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_varplot.R
\name{nice_varplot}
\alias{nice_varplot}
\title{Attempt to visualize variance per group}
\usage{
nice_varplot(
  data,
  variable,
  group,
  colours,
  groups.labels,
  grid = TRUE,
  shapiro = FALSE,
  ytitle = variable
)
}
\arguments{
\item{data}{The data frame}

\item{variable}{The dependent variable to be plotted.}

\item{group}{The group by which to plot the variable.}

\item{colours}{Desired colours for the plot, if desired.}

\item{groups.labels}{How to label the groups.}

\item{grid}{Logical, whether to keep the default background
grid or not. APA style suggests not using a grid in the
background, though in this case some may find it useful to
more easily estimate the slopes of the different groups.}

\item{shapiro}{Logical, whether to include the p-value from
the Shapiro-Wilk test on the plot.}

\item{ytitle}{An optional y-axis label, if desired.}
}
\value{
A scatter plot of class ggplot attempting to display the
group variances. Also includes the max variance ratio
(maximum variance divided by the minimum variance).
}
\description{
Attempt to visualize variance per group.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE) && requireNamespace("ggrepel", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Make the basic plot
nice_varplot(
  data = iris,
  variable = "Sepal.Length",
  group = "Species"
)

# Further customization
nice_varplot(
  data = iris,
  variable = "Sepal.Length",
  group = "Species",
  colours = c(
    "#00BA38",
    "#619CFF",
    "#F8766D"
  ),
  ytitle = "Sepal Length",
  groups.labels = c(
    "(a) Setosa",
    "(b) Versicolor",
    "(c) Virginica"
  )
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_assumptions}}, \code{\link{nice_density}},
\code{\link{nice_normality}}, \code{\link{nice_qq}},
\code{\link{nice_var}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{variance}
