% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseason.R
\docType{methods}
\name{deseason}
\alias{deseason}
\alias{deseason,RasterStackBrick-method}
\alias{deseason,numeric-method}
\title{Create seasonal anomalies}
\usage{
\S4method{deseason}{RasterStackBrick}(x, cycle.window = 12L,
  use.cpp = FALSE, filename = "", ...)

\S4method{deseason}{numeric}(x, cycle.window = 12L)
}
\arguments{
\item{x}{An object of class 'RasterStack' (or 'RasterBrick') or, 
alternatively, a 'numeric' time series.}

\item{cycle.window}{Integer. The window for the creation of the anomalies.}

\item{use.cpp}{Logical. Determines whether or not to use \strong{Rcpp} 
functionality, defaults to \code{TRUE}. Only applies if \code{x} is a 
'RasterStack' (or 'RasterBrick') object.}

\item{filename}{\code{character}. Output filename (optional).}

\item{...}{Additional arguments passed on to \code{\link{writeRaster}}, only 
considered if \code{filename} is specified.}
}
\value{
If \code{x} is a 'RasterStack' (or 'RasterBrick') object, a 
deseasoned 'RasterStack'; else a deseasoned 'numeric' vector.
}
\description{
The function calculates anomalies of a RasterStack by supplying a 
suitable seasonal window. E. g. to create monthly anomalies of a 
raster stack of 12 layers per year, use \code{cycle.window = 12}.
}
\examples{
data("australiaGPCP")

aus_dsn <- deseason(australiaGPCP, 12)

opar <- par(mfrow = c(1,2))
plot(australiaGPCP[[1]], main = "original")
plot(aus_dsn[[1]], main = "deseasoned")
par(opar)
}
\seealso{
\code{\link{anomalize}}, \code{\link{denoise}}
}

