% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cutStack}
\alias{cutStack}
\title{Shorten a RasterStack}
\usage{
cutStack(x, tail = TRUE, n = NULL)
}
\arguments{
\item{x}{a RasterStack}

\item{tail}{logical. If \code{TRUE} the layers will be taken off
the end of the stack. If \code{FALSE} layers will be taken off
the beginning.}

\item{n}{the number of layers to take away.}
}
\value{
a RasterStack shortened by \code{n} layers either from the
beginning or the end, depending on the specification of \code{tail}
}
\description{
The function cuts a specified number of layers off a RrasterStack in
order to create lagged RasterStacks.
}
\examples{
data(australiaGPCP)

# 6 layers from the beginning
cutStack(australiaGPCP, tail = FALSE, n = 6)
# 8 layers from the end
cutStack(australiaGPCP, tail = TRUE, n = 8)
}

