% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchBMdata.R
\name{fetchBMdata}
\alias{fetchBMdata}
\title{Retrieve data from Budowle and Moretti (1999) from the web}
\usage{
fetchBMdata(url = NULL, id = NULL)
}
\arguments{
\item{url}{- the location of the webpage this data is stored on. If
\code{NULL} then hardcoded values in the function are used. The argument
allows the user to get the function to work given this values may change.
However, it is unlikely that it will help.}

\item{id}{- the id of the HTML element where the data is stored on the
webpage. If \code{NULL} then a hardcoded value in the function is used. The
argument allows the user to get the function to work given this values may
change. However, it is unlikely that it will help. NOTE: this is super
flakey because of how the FBI web authors have created it. This may change
in which case, the function will more likely change than the id.}
}
\value{
A list consisting of six elements corresponding to the six
populations detailed in the data set. Each of the list elements is a list in
itself with three further elements named \code{loci}, \code{profiles} and \code{freqs}. 
\code{loci} is a vector of the 13-20 STR locus names. \code{freqs} is a list of 13-20 
vectors, each vector contains the allele frequencies. \code{profiles} contains the 
raw profiles that the allele frequency tables were constructed from.
}
\description{
Retreives the Budowle and Moretti (1999) and compiles the allele frequency
tables needed for the other parts of this package such as \code{sim}.
}
\details{
The first three populations have data on 20 loci, the second three on 13
loci. The missing values (0's in the raw data) have been dropped and are not
used in calculating the frequencies. This function will not work if you are
not connected to the internet, or access to the internet is blocked.
}
\examples{

## not run
\dontrun{
db = fetchBMdata()
names(db)
f = db[["TRINIDADIAN"]]$freqs
dbExpect(f, k = "UN", collapse = TRUE)
}

}
\references{
Budowle, B. and Moretti, T.R. (1999), \emph{Genotype Profiles
for Six Population Groups at the 13 CODIS Short Tandem Repeat Core Loci and
Other PCR Based Loci}, Forensic Science Communications 1(2).
}
\seealso{
fbiCaucs, USCaucs
}
\author{
James M. Curran
}
\keyword{datasets}
