% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_gridworld.R
\name{WindyGridworld}
\alias{WindyGridworld}
\alias{windy.gridworld}
\title{Windy Gridworld}
\arguments{
\item{...}{[\code{any}] \cr Arguments passed on to \link{makeEnvironment}.}
}
\description{
Windy Gridworld problem for reinforcement learning. Actions include
going left, right, up and down. In each column the wind pushes you up a
specific number of steps (for the next action). If an action would
take you off the grid, you remain in the previous state. For each step you
get a reward of -1, until you reach into a terminal state.
}
\details{
This is the gridworld (goal state denoted G, start state denoted S).
The last row specifies the upward wind in each column.
\tabular{rrrrrrrrrr}{
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
S \tab . \tab . \tab . \tab . \tab . \tab . \tab G \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
0 \tab 0 \tab 0 \tab 1 \tab 1 \tab 1 \tab 2 \tab 2 \tab 1 \tab 0 \cr
}
}
\section{Usage}{

\code{makeEnvironment("windy.gridworld", ...)}
}

\section{Methods}{

\itemize{
\item \code{$step(action)} \cr
Take action in environment.
Returns a list with \code{state}, \code{reward}, \code{done}.
\item \code{$reset()} \cr
Resets the \code{done} flag of the environment and returns an initial state.
Useful when starting a new episode.
\item \code{$visualize()} \cr
Visualizes the environment (if there is a visualization function).
}
}

\examples{
env = makeEnvironment("windy.gridworld")
}
\references{
Sutton and Barto (Book draft 2017): Reinforcement Learning: An Introduction Example 6.5
}
