% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_gym.R
\name{GymEnvironment}
\alias{GymEnvironment}
\title{Gym Environment}
\arguments{
\item{gym.name}{[\code{character(1)}] \cr
Name of gym environment, e.g. \code{"CartPole-v0"}.}

\item{...}{[\code{any}] \cr Arguments passed on to \link{makeEnvironment}.}
}
\description{
Reinforcement learning environment from OpenAI Gym.
}
\details{
For available gym environments take a look at https://gym.openai.com/envs.
}
\section{Usage}{

\code{makeEnvironment("gym", gym.name, ...)}
}

\section{Installation}{

For installation of the python package \code{gym} see
https://github.com/openai/gym#installation.
Then install the R package \code{reticulate}.
}

\section{Methods}{

\itemize{
\item \code{$close()}
Close visualization window.
}


\itemize{
\item \code{$step(action)} \cr
Take action in environment.
Returns a list with \code{state}, \code{reward}, \code{done}.
\item \code{$reset()} \cr
Resets the \code{done} flag of the environment and returns an initial state.
Useful when starting a new episode.
\item \code{$visualize()} \cr
Visualizes the environment (if there is a visualization function).
}
}

\examples{
\dontrun{
# Create an OpenAI Gym environment.
# Make sure you have Python, gym and reticulate installed.
env = makeEnvironment("gym", gym.name = "MountainCar-v0")
env$reset()
env$close()
}
}
