% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_gridworld.R
\name{CliffWalking}
\alias{CliffWalking}
\alias{cliff.walking}
\title{Cliff Walking}
\arguments{
\item{...}{[\code{any}] \cr Arguments passed on to \link{makeEnvironment}.}
}
\description{
Gridworld environment for reinforcement learning from Sutton & Barto (2017).
Grid of shape 4x12 with a goal state in the bottom right of the grid.
Episodes start in the lower left state. Possible actions include going left, right, up and down.
Some states in the lower part of the grid are a cliff,
so taking a step into this cliff will yield a high negative reward of - 100 and move the agent
back to the starting state.
Elsewise rewards are - 1, for the goal state 0.
}
\details{
This is the gridworld (goal state denoted G, cliff states denoted C, start state denoted S):
\tabular{rrrrrrrrrrrr}{
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
. \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \tab . \cr
S \tab C \tab C \tab C \tab C \tab C \tab C \tab C \tab C \tab C \tab C \tab G \cr
}
}
\section{Usage}{

\code{makeEnvironment("cliff.walking", ...)}
}

\section{Methods}{

\itemize{
\item \code{$step(action)} \cr
Take action in environment.
Returns a list with \code{state}, \code{reward}, \code{done}.
\item \code{$reset()} \cr
Resets the \code{done} flag of the environment and returns an initial state.
Useful when starting a new episode.
\item \code{$visualize()} \cr
Visualizes the environment (if there is a visualization function).
}
}

\examples{
env = makeEnvironment("cliff.walking")
}
\references{
Sutton and Barto (Book draft 2017): Reinforcement Learning: An Introduction Example 6.6
}
