% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regnet.R
\name{plot.regnet}
\alias{plot.regnet}
\title{plot a regnet object}
\usage{
\method{plot}{regnet}(x, subnetworks=FALSE, vsize=10, labelDist=2, minVertices=2, theta=5, \dots)
}
\arguments{
\item{x}{a regnet object.}

\item{subnetworks}{whether to plot sub-networks}

\item{vsize}{the size of the vertex}

\item{labelDist}{the distance of the label from the center of the vertex.}

\item{minVertices}{the minimum number of vertices a sub-network should contain.}

\item{theta}{the multiplier for the width of the edge. Specifically, \eqn{edge.width=\theta\times adjacency}. The default is 5.}

\item{...}{other plot arguments}
}
\value{
an object of class "igraph" is returned in default.
When \emph{subnetworks=TRUE}, a list of "igraph" objects (sub-networks) is returned.
}
\description{
plot the network structures of the identified genetic variants.
}
\details{
This function depends on the "igraph" package in generating the network graphs. It returns a (list of) igraph object(s),
on which users can do further modification on the network graphs.
}
\examples{
\donttest{
data(ContExample)
X = rgn.tcga$X
Y = rgn.tcga$Y
clv = (1:2)
fit = regnet(X, Y, "continuous", "network", rgn.tcga$lamb1, rgn.tcga$lamb2, clv =clv, alpha.i=0.5)

plot(fit)
plot(fit, subnetworks = TRUE, vsize=20, labelDist = 3, theta = 5)
}

}
\seealso{
\code{\link{regnet}}
}
