% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_package_information.R,
%   R/01_regmedint_class_ui.R
\docType{package}
\name{regmedint}
\alias{regmedint}
\title{regmedint: A package for regression-based causal mediation analysis}
\usage{
regmedint(
  data,
  yvar,
  avar,
  mvar,
  cvar,
  eventvar = NULL,
  a0,
  a1,
  m_cde,
  c_cond,
  mreg,
  yreg,
  interaction = TRUE,
  casecontrol = FALSE
)
}
\arguments{
\item{data}{Data frame containing the relevant variables.}

\item{yvar}{A character vector of length 1. Outcome variable name. It should be the time variable for survival outcomes.}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{mvar}{A character vector of length 1. Mediator variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there should usually be some confounder(s) to account for the common cause structure (confounding) between \code{avar} and \code{yvar}.}

\item{eventvar}{An character vector of length 1. Only required for survival outcome regression models. Note that the coding is 1 for event and 0 for censoring, following the R survival package convention.}

\item{a0}{A numeric vector of length 1. Reference level of treatment variable that is considered "untreated" or "unexposed".}

\item{a1}{A numeric vector of length 1.}

\item{m_cde}{A numeric vector of length 1. Mediator level at which controlled direct effect is evaluated at.}

\item{c_cond}{A numeric vector of the same length as \code{cvar}. Covariate vector at which conditional effects are evaluated at.}

\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{yreg}{A character vector of length 1. Outcome regression type: \code{"linear"}, \code{"logistic"}, \code{"loglinear"}, \code{"poisson"}, \code{"negbin"}, \code{"survCox"}, \code{"survAFT_exp"}, or \code{"survAFT_weibull"}.}

\item{interaction}{A logical vector of length 1. Default to TRUE. Whether to include a mediator-treatment interaction term in the outcome regression model.}

\item{casecontrol}{A logical vector of length 1. Default to FALSE. Whether data comes from a case-control study.}
}
\value{
regmedint object, which is a list containing the mediator regression object, the outcome regression object, and the regression-based mediation results.
}
\description{
The package is a simple R implementation of the SAS macro as described in Valeri & VanderWeele 2013 and Valeri & VanderWeele 2015 \url{https://www.hsph.harvard.edu/tyler-vanderweele/tools-and-tutorials/}.

This is a user-interface for regression-based causal mediation analysis as described in Valeri & VanderWeele 2013 and Valeri & VanderWeele 2015.
}
\section{Fitting models}{

Use the regmedint function to fit models and set up regression-based causal mediation analysis.
}

\section{Examining results}{

Several methods are available to examine the regmedint object.
print
summary
coef
confint
FIXME: Document once implemented.
}

\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
summary(regmedint_obj)

}
