% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewise_parametric_hinv.R
\name{piecewise_parametric_hinv}
\alias{piecewise_parametric_hinv}
\title{Create two-parameter piecewise (inverse) warping functions}
\usage{
piecewise_parametric_hinv(grid, beta = 0.01, midpoint_percentile = 0.5)
}
\arguments{
\item{grid}{grid of values over which to evaluate the function.}

\item{beta}{parameter that controls shape of warping. Result 
approaches identity warp as beta approaches zero.}

\item{midpoint_percentile}{controls where the result crosses the identity warp. 
Default is 0.5, which forces result to cross identity line at median of grid.}
}
\value{
A numeric vector containing values for a single warping function.
}
\description{
This function uses a parametric model to calculate inverse warping functions for 
registration. The parameter \code{beta} controls the shape of warping,
and the parameter \code{midpoint_percentile} control where the warping function
crosses the identity line. The designation (inverse) is intended to 
communicate that these functions take data from the unregistered space to the 
registered space, consistent with functional data literature on registration.
}
\examples{
x = runif(100)
plot(x, type = 'l')
lines(piecewise_parametric_hinv(grid = x, beta = 0.5), col = "red")
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu}
}
