% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_construct}
\alias{get_construct}
\title{Extract Script from \code{reverse_construct} to \code{construct} a
\code{regexr} Object.}
\usage{
get_construct(x, file = "", ...)
}
\arguments{
\item{x}{A \code{reverse_construct} object.}

\item{file}{A connection, or a character string naming the file to print to.
If "" (the default), \code{\link[base]{cat}} prints to the console unless
redirected by \code{\link[base]{sink}}.  Windows users may use
\code{file = "clipboard"} to copy the content to the clipboard.}

\item{\ldots}{Other arguments passed to \code{\link[regexr]{print.reverse_construct}}.}
}
\value{
Returns an auto-commented script used to \code{construct} a
\code{regexr} object.
}
\description{
Pulls the \code{reverse_construct} attribute from a \code{reverse_construct}.
This script can be assigned to an object and run in the console to create a
comments, named \code{regexr} object.
}
\examples{
library("qdapRegex")
(myregex <- grab("@rm_time2"))
out <- as.regexr(myregex)

out
summary(out)
comments(out)
subs(out)
test(out)
get_construct(out)

\dontrun{
## On Windows copy to clipboard
get_construct(out, file="clipboard")
}
}

