% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_alpha_proxy}
\alias{d_alpha_proxy}
\title{Partial derivatives for mean impact equation using proxy data.}
\usage{
d_alpha_proxy(
  p_impact,
  prox_data,
  mean_predictors,
  var_predictors,
  cov,
  samp_size,
  num_items
)
}
\arguments{
\item{p_impact}{Vector of impact parameters.}

\item{prox_data}{Matrix of observed proxy scores.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{cov}{Covariate being maximized.}

\item{samp_size}{Sample size in data set.}

\item{num_items}{Number of items in data set.}
}
\value{
a \code{"list"} of first and second partial derivatives for mean impact equation (to
use with coordinate descent and univariate Newton-Raphson)
}
\description{
Partial derivatives for mean impact equation using proxy data.
}
\keyword{internal}
