% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.regDIF.R
\name{se.regDIF}
\alias{se.regDIF}
\title{Standard Errors for regDIF Model(s)}
\usage{
se.regDIF(fit,
          se.type = "sem",
          tau = NULL,
          ...)
}
\arguments{
\item{fit}{A regDIF fitted model object of class \code{regDIF}.
Upon designating \code{fit}, the default is to obtain standard errors
for the best-fitting model according to the minimum BIC model.}

\item{se.type}{Character value indicating the method of computing standard
errors for a regDIF fitted model. Default is "sem", or the supplemental EM
algorithm (see Cai, 2008). Other options are in development and not yet
supported.}

\item{tau}{Optional numeric or vector of tau values corresponding to those
already fit in \code{fit}.}

\item{...}{Additional arguments to pass to regDIF function if different
settings are desired.}
}
\value{
Function returns an object of class \code{se.regDIF}
}
\description{
Obtain standard errors for regDIF model(s).
}
\keyword{internal}
