% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VB_Mult_Wish.R
\name{vb_mult_wish}
\alias{vb_mult_wish}
\title{Multilevel FoSR using Variational Bayes and Wishart prior}
\usage{
vb_mult_wish(formula, data = NULL, verbose = TRUE, Kt = 5, alpha = 0.1,
  min.iter = 10, max.iter = 50, Az = NULL, Bz = NULL, Aw = NULL,
  Bw = NULL, v = NULL)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{data}{an optional data frame, list or environment containing the 
variables in the model. If not found in data, the variables are taken from 
environment(formula), typically the environment from which the function is 
called.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{alpha}{tuning parameter balancing second-derivative penalty and
zeroth-derivative penalty (alpha = 0 is all second-derivative penalty)}

\item{min.iter}{minimum number of interations of VB algorithm}

\item{max.iter}{maximum number of interations of VB algorithm}

\item{Az}{hyperparameter for inverse gamma controlling variance of spline terms
for subject-level effects}

\item{Bz}{hyperparameter for inverse gamma controlling variance of spline terms
for subject-level effects}

\item{Aw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{Bw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{v}{hyperparameter for inverse Wishart prior on residual covariance}
}
\description{
Fitting function for function-on-scalar regression for cross-sectional data.
This function estimates model parameters using VB and estimates
the residual covariance surface using a Wishart prior. If prior hyperparameters
are \code{NULL} they are estimated using the data.
}
\references{
Goldsmith, J., Kitago, T. (2016).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical 
Function-on-Scalar Regression. \emph{Journal of the Royal Statistical Society:
Series C}, 65 215-236.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
