% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VB_Mult_FPCA.R
\name{vb_mult_fpca}
\alias{vb_mult_fpca}
\title{Multilevel FoSR using Variational Bayes and FPCA}
\usage{
vb_mult_fpca(formula, data = NULL, verbose = TRUE, Kt = 5, Kp = 2,
  alpha = 0.1)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{data}{an optional data frame, list or environment containing the
variables in the model. If not found in data, the variables are taken from
environment(formula), typically the environment from which the function is
called.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{Kp}{number of FPCA basis functions to be estimated}

\item{alpha}{tuning parameter balancing second-derivative penalty and
zeroth-derivative penalty (alpha = 0 is all second-derivative penalty)}
}
\description{
Fitting function for function-on-scalar regression for multilevel data.
This function estimates model parameters using a VB and estimates
the residual covariance surface using FPCA.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
\references{
Goldsmith, J., Kitago, T. (Under Review).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical
Function-on-Scalar Regression.
}

