#' A Estrada Glycation and Inflammation Study (AEGIS) Data
#'
#' The aegis dataset was obtained from the Estrada Glycation and Inflammation
#' (AEGIS) project. A cross sectional, population based study that was
#' performed in the municipality of  A Estrada (Galicia, NW Spain). The study
#' objective was to investigate the association between glycation, inflammation
#' status, lifestyle and common diseases, and reasons for glycemic markers
#' discordances (Gude et al., 2017).
#'
#' @format A data frame containing 1516 observations, and 7 variables:
#' \describe{
#'   \item{id}{Anonymized patient identificator.}
#'   \item{gender}{A factor variable describing patient gender, (female, and male).}
#'   \item{age}{Patients' age.}
#'   \item{dm}{Diabetes mellitus indicator (no, and yes).}
#'   \item{fpg}{Fasting plasma glucose levels (mg/dL).}
#'   \item{hba1c}{Glycated hemoglobin percentage.}
#'   \item{fru}{Fructosamine concentration (mg/dL).}
#'}
#' @references Gude F, Diaz--Vidal P, Rua--Perez C, et al. Glycemic variability and its association with demographics and lifestyles in ageneral adult population. J Diabetes Sci Technol. 2017; 11(4): 780--790
"aegis"
