% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getRI}
\alias{getRI}
\title{Method to calculate reference intervals (percentiles) for objects of class 'RWDRI'}
\usage{
getRI(
  x,
  RIperc = c(0.025, 0.975),
  CIprop = 0.95,
  pointEst = c("fullDataEst", "medianBS"),
  Scale = c("original", "transformed")
)
}
\arguments{
\item{x}{(object) of class 'RWDRI'}

\item{RIperc}{(numeric) value specifying the percentiles, which define the reference interval}

\item{CIprop}{(numeric) value specifying the central region for estimation of confidence intervals}

\item{pointEst}{(character) specifying the point estimate determination: (1) using the full dataset ("fullDataEst"),
(2) calculating the median from the bootstrap samples ("medianBS"), (2) works only if NBootstrap > 0}

\item{Scale}{(character) specifying if percentiles are calculated on the original scale ("Or") or the transformed scale ("Tr")}
}
\value{
(data.frame) with columns for percentile, point estimate and confidence intervals.
}
\description{
Method to calculate reference intervals (percentiles) for objects of class 'RWDRI'
}
\author{
Christopher Rank \email{christopher.rank@roche.com}, Tatjana Ammer \email{tatjana.ammer@roche.com}
}
