% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_clean.R
\name{refdb_clean_tax_remove_extra}
\alias{refdb_clean_tax_remove_extra}
\title{Remove extra words from taxonomic names}
\usage{
refdb_clean_tax_remove_extra(x, cols = NULL)
}
\arguments{
\item{x}{a reference database.}

\item{cols}{an optional vector of column names.
If \code{NULL} (default), the function is applied to the columns
associated with the \code{taxonomy} and \code{organism} fields.}
}
\value{
A reference database.

lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_clean_tax_remove_extra(lib)
}
\description{
Remove extra words from taxonomic names
}
\details{
As the function can match words like "g.", "s." or "x", which can
have a signification in some nomenclatures, it is recommended to
execute \link{refdb_clean_tax_harmonize_nomenclature} first.
}
