% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_sub_admin}
\alias{splits_sub_admin}
\title{Compute Number of Sub-Administrative Units Split}
\usage{
splits_sub_admin(plans, shp, sub_admin)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{sub_admin}{unqouted name of column in shp with numeric identifiers for subsidiary administrative units}
}
\value{
numeric vector
}
\description{
Compute Number of Sub-Administrative Units Split
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
splits_sub_admin(plans = nh$r_2020, shp = nh, sub_admin = county)

# Or many plans:
splits_sub_admin(plans = nh_m[, 3:5], shp = nh, sub_admin = county)

}
\concept{splits}
