% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_ms.R
\name{redist_mergesplit}
\alias{redist_mergesplit}
\title{Merge-Split/Recombination MCMC Redistricting Sampler}
\usage{
redist_mergesplit(
  map,
  nsims,
  warmup = max(100, nsims\%/\%2),
  thin = 1L,
  init_plan = NULL,
  counties = NULL,
  compactness = 1,
  constraints = list(),
  constraint_fn = function(m) rep(0, ncol(m)),
  adapt_k_thresh = 0.98,
  k = NULL,
  init_name = NULL,
  verbose = FALSE,
  silent = FALSE
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{nsims}{The number of samples to draw, including warmup.}

\item{warmup}{The number of warmup samples to discard. Recommended to be at
least the first 20\% of samples, and in any case no less than around 100
samples.}

\item{thin}{Save every \code{thin}-th sample. Defaults to no thinning (1).}

\item{init_plan}{The initial state of the map. If not provided, will default to
the reference map of the \code{map} object, or if none exists, will sample
a random initial state using \code{\link{redist_smc}}. You can also request
a random initial state by setting \code{init_plan="sample"}.}

\item{counties}{A vector containing county (or other administrative or
geographic unit) labels for each unit, which may be integers ranging from 1
to the number of counties, or a factor or character vector.  If provided,
the algorithm will generate maps tend to follow county lines. There is no
strength parameter associated with this constraint. To adjust the number of
county splits further, or to constrain a second type of administrative
split, consider using \code{add_constr_splits()}, \code{add_constr_multisplits()},
and \code{add_constr_total_splits()}.}

\item{compactness}{Controls the compactness of the generated districts, with
higher values preferring more compact districts. Must be nonnegative. See the
'Details' section for more information, and computational considerations.}

\item{constraints}{A list containing information on constraints to implement.
See the 'Details' section for more information.}

\item{constraint_fn}{A function which takes in a matrix where each column is
a redistricting plan and outputs a vector of log-weights, which will be
added the the final weights.}

\item{adapt_k_thresh}{The threshold value used in the heuristic to select a
value \code{k_i} for each splitting iteration. Set to 0.9999 or 1 if
the algorithm does not appear to be sampling from the target distribution.
Must be between 0 and 1.}

\item{k}{The number of edges to consider cutting after drawing a spanning
tree. Should be selected automatically in nearly all cases.}

\item{init_name}{a name for the initial plan, or \code{FALSE} to not include
the initial plan in the output.  Defaults to the column name of the
existing plan, or "\code{<init>}" if the initial plan is sampled.}

\item{verbose}{Whether to print out intermediate information while sampling.
Recommended.}

\item{silent}{Whether to suppress all diagnostic information.}
}
\value{
\code{redist_mergesplit} returns an object of class
\code{\link{redist_plans}} containing the simulated plans.
}
\description{
\code{redist_mergesplit} uses a Markov Chain Monte Carlo algorithm to
generate congressional or legislative redistricting plans according to
contiguity, population, compactness, and administrative boundary constraints.
The MCMC proposal is the same as is used in the SMC sampler; it is similar
but not identical to those used in the references.  1-level hierarchical
Merge-split is supported through the \code{counties} parameter; unlike in
the SMC algorithm, this does not guarantee a maximum number of county splits.
}
\details{
This function draws samples from a specific target measure, controlled by the
\code{map}, \code{compactness}, and \code{constraints} parameters.

Key to ensuring good performance is monitoring the acceptance rate, which
is reported at the sample level in the output.
Users should also check diagnostics of the sample by running
\code{summary.redist_plans()}.

Higher values of \code{compactness} sample more compact districts;
setting this parameter to 1 is computationally efficient and generates nicely
compact districts.
}
\examples{
\donttest{
data(fl25)

fl_map <- redist_map(fl25, ndists = 3, pop_tol = 0.1)

sampled_basic <- redist_mergesplit(fl_map, 10000)

sampled_constr <- redist_mergesplit(fl_map, 10000, constraints = list(
    incumbency = list(strength = 1000, incumbents = c(3, 6, 25))
))
}

}
\references{
Carter, D., Herschlag, G., Hunter, Z., and Mattingly, J. (2019). A
merge-split proposal for reversible Monte Carlo Markov chain sampling of
redistricting plans. arXiv preprint arXiv:1911.01503.

DeFord, D., Duchin, M., and Solomon, J. (2019). Recombination: A family of
Markov chains for redistricting. arXiv preprint arXiv:1911.05725.
}
\concept{simulate}
