% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_mcmc.R
\name{redist.flip.anneal}
\alias{redist.flip.anneal}
\title{Flip MCMC Redistricting Simulator using Simulated Annealing}
\usage{
redist.flip.anneal(
  adj,
  total_pop,
  ndists = NULL,
  init_plan = NULL,
  num_hot_steps = 40000,
  num_annealing_steps = 60000,
  num_cold_steps = 20000,
  eprob = 0.05,
  lambda = 0,
  pop_tol = NULL,
  group_pop = NULL,
  areasvec = NULL,
  counties = NULL,
  borderlength_mat = NULL,
  ssdmat = NULL,
  constraint = NULL,
  constraintweights = NULL,
  compactness_metric = "fryer-holden",
  partisan_metric = "efficiency-gap",
  rngseed = NULL,
  maxiterrsg = 5000,
  adapt_lambda = FALSE,
  adapt_eprob = FALSE,
  exact_mh = FALSE,
  savename = NULL,
  verbose = TRUE,
  ncores = 1,
  tgt_min = 0.55,
  tgt_other = 0.25,
  rvote = NULL,
  dvote = NULL,
  minorityprop = NULL
)
}
\arguments{
\item{adj}{adjacency matrix, list, or object of class
"SpatialPolygonsDataFrame."}

\item{total_pop}{A vector containing the populations of each geographic
unit}

\item{ndists}{The number of congressional districts. The default is
\code{NULL}.}

\item{init_plan}{A vector containing the congressional district labels
of each geographic unit. If not provided, random and contiguous congressional
district assignments will be generated using \code{redist_smc}. To use the old
behavior of generating with \code{redist.rsg}, provide init_plan = 'rsg'.}

\item{num_hot_steps}{The number of steps to run the simulator at beta = 0.
Default is 40000.}

\item{num_annealing_steps}{The number of steps to run the simulator with
linearly changing beta schedule. Default is 60000}

\item{num_cold_steps}{The number of steps to run the simulator at beta = 1.
Default is 20000.}

\item{eprob}{The probability of keeping an edge connected. The
default is \code{0.05}.}

\item{lambda}{The parameter determining the number of swaps to attempt
each iteration of the algorithm. The number of swaps each iteration is
equal to Pois(\code{lambda}) + 1. The default is \code{0}.}

\item{pop_tol}{The strength of the hard population
constraint. \code{pop_tol} = 0.05 means that any proposed swap that
brings a district more than 5\% away from population parity will be
rejected. The default is \code{NULL}.}

\item{group_pop}{A vector of populations for some sub-group of
interest. The default is \code{NULL}.}

\item{areasvec}{A vector of precinct areas for discrete Polsby-Popper.
The default is \code{NULL}.}

\item{counties}{A vector of county membership assignments. The default is \code{NULL}.}

\item{borderlength_mat}{A matrix of border length distances, where
the first two columns are the indices of precincts sharing a border and
the third column is its distance. Default is \code{NULL}.}

\item{ssdmat}{A matrix of squared distances between geographic
units. The default is \code{NULL}.}

\item{constraint}{Which constraint to apply. Accepts any combination of \code{compact},
\code{segregation}, \code{vra}, \code{population}, \code{similarity}, \code{partisan},
\code{minority}, \code{hinge}, \code{countysplit}, or \code{none}
(no constraint applied). The default is NULL.}

\item{constraintweights}{The weights to apply to each constraint. Should be a vector
the same length as constraint. Default is NULL.}

\item{compactness_metric}{The compactness metric to use when constraining on
compactness. Default is \code{fryer-holden}, the other implemented options
are \code{polsby-popper} and \code{edges-removed}.}

\item{partisan_metric}{The partisan metric to use when constraining on partisan metrics.
Only implemented are "efficiency-gap" (default) and "proportional-representation".}

\item{rngseed}{Allows the user to set the seed for the
simulations. Default is \code{NULL}.}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{exact_mh}{Whether to use the approximate (0) or exact (1)
Metropolis-Hastings ratio calculation for accept-reject rule. Default is FALSE.}

\item{savename}{Filename to save simulations. Default is \code{NULL}.}

\item{verbose}{Whether to print initialization statement.
Default is \code{TRUE}.}

\item{ncores}{The number of cores available to parallelize over. Default is 1.}

\item{tgt_min}{The majority minority target percent as a decimal. Default is 0.55.}

\item{tgt_other}{The remaining target percent as a decimal. Default is 0.25.}

\item{rvote}{integer vector of votes for Republicans by precinct}

\item{dvote}{integer vector of votes for Democrats by precinct}

\item{minorityprop}{numeric vector of targeted minority proportions for the top
districts with that proportion}
}
\value{
list of class redist
}
\description{
\code{redist.flip.anneal} simulates congressional redistricting plans
using Markov chain Monte Carlo methods coupled with simulated annealing.
}
\concept{simulate}
