% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVersion.R
\name{exportVersion}
\alias{exportVersion}
\alias{exportVersion.redcapApiConnection}
\title{Export the REDCap Version Number}
\usage{
exportVersion(rcon, ...)

\method{exportVersion}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Returns a character value giving the version number.

IF this function is used in a version of REDCap that does not support
the method (prior to version 6.0.0), the value "5.12.2" will be returned.
This is done solely for the convenience of always returning a value
that can be compared against other versions.
}
\description{
These methods enable the user to export the REDCap instance
version number.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export the version number
exportVersion(rcon)
}

}
