% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportProjectInformation.R
\name{exportProjectInformation}
\alias{exportProjectInformation}
\alias{exportProjectInformation.redcapApiConnection}
\title{Exports the Project Information}
\usage{
exportProjectInformation(rcon, ...)

\method{exportProjectInformation}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Retrieve a data frame with the project information.
}
\details{
If this function is used in a version of REDCap that does not
  support the Export Version Number function, the character string
  \code{'Version Unknown'} is returned.
}
\section{REDCap API Documentation (6.5.0)}{

This function allows you to export some of the basic attributes of a given 
REDCap project, such as the project's title, if it is longitudinal, if 
surveys are enabled, the time the project was created and moved to production, etc.
}

\section{REDCap Version}{

6.5.0 (Perhaps earlier)
}

\section{Known REDCap Limitations}{

None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
