% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteFromFileRepository.R
\name{deleteFromFileRepository}
\alias{deleteFromFileRepository}
\alias{deleteFromFileRepository.redcapApiConnection}
\title{Delete a Single File from the File Repository}
\usage{
deleteFromFileRepository(rcon, doc_id, ...)

\method{deleteFromFileRepository}{redcapApiConnection}(
  rcon,
  doc_id,
  ...,
  refresh = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{doc_id}{\code{integerish(1)} The document ID of the file to be 
deleted.}

\item{...}{Arguments to pass to other methods.}

\item{refresh}{\code{logical(1)} When \code{TRUE} (default), the cached 
File Repository data on \code{rcon} will be refreshed.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Deletes a single file from the File Respository based on 
  its document ID.
}
\details{
This method allows you to delete a single file in a project's 
File Repository. Once deleted, the file will remain in the Recycle Bin 
folder for up to 30 days.
}
\author{
Benjamin Nutter
}
