% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsRecordsMethods.R, R/exportRecords.R,
%   R/exportRecords_offline.R, R/exportReports.R
\name{recordsMethods}
\alias{recordsMethods}
\alias{exportRecords}
\alias{exportRecords_offline}
\alias{exportReports}
\alias{exportRecords.redcapApiConnection}
\alias{exportReports.redcapApiConnection}
\title{Export Records and Reports}
\usage{
exportRecords(
  rcon,
  factors = TRUE,
  fields = NULL,
  forms = NULL,
  records = NULL,
  events = NULL,
  labels = TRUE,
  dates = TRUE,
  drop = NULL,
  survey = TRUE,
  dag = TRUE,
  checkboxLabels = FALSE,
  colClasses = character(0),
  ...
)

exportRecords_offline(
  dataFile,
  metaDataFile,
  factors = TRUE,
  fields = NULL,
  forms = NULL,
  labels = TRUE,
  dates = TRUE,
  checkboxLabels = FALSE,
  colClasses = NA,
  ...,
  meta_data
)

exportReports(
  rcon,
  report_id,
  factors = TRUE,
  labels = TRUE,
  dates = TRUE,
  drop = NULL,
  checkboxLabels = FALSE,
  ...
)

\method{exportRecords}{redcapApiConnection}(
  rcon,
  factors = TRUE,
  fields = NULL,
  forms = NULL,
  records = NULL,
  events = NULL,
  labels = TRUE,
  dates = TRUE,
  drop = NULL,
  survey = TRUE,
  dag = TRUE,
  checkboxLabels = FALSE,
  colClasses = character(0),
  ...,
  batch.size = -1,
  form_complete_auto = TRUE
)

\method{exportReports}{redcapApiConnection}(
  rcon,
  report_id,
  factors = TRUE,
  labels = TRUE,
  dates = TRUE,
  drop = NULL,
  checkboxLabels = FALSE,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{report_id}{\code{integerish(1)}. Gives the report id of the desired report.
This is located on the Report Builder page of the user interface.}

\item{factors}{\code{logical(1)}.  When \code{TRUE}, multiple choice fields
will be returned as factors. Otherwise, they are returned as
character values. See 'Exporting Records'
for more on how this interacts with the \code{checkboxLabels} argument.}

\item{fields}{\code{character}. Fields to be returned.  When \code{NULL},
all fields are returned.}

\item{forms}{\code{character}. Forms to be returned.  When \code{NULL},
all forms are returned.}

\item{records}{\code{character} or \code{integerish}. Record ID's to be
returned.  When \code{NULL}, all records are returned.}

\item{events}{\code{character}. Events to be returned from a
longitudinal database.  When \code{NULL}, all events are returned.}

\item{labels}{\code{logical(1)}. When \code{TRUE}, field labels are
attached to each column as an attribute.}

\item{dates}{\code{logical(1)}. When \code{TRUE}, date variables are converted to
\code{POSIXct} objects.}

\item{drop}{\code{character}. An optional vector of REDCap field names to
remove from the dataset. Ignored when \code{NULL}. Any fields in this
argument that do not exist in the project will be ignored.}

\item{survey}{\code{logical(1)}. specifies whether or not to export the survey identifier field
(\code{redcap_survey_identifier}) or survey timestamp fields
(\verb{[form_name]_timestamp}) when surveys are utilized in the project.}

\item{dag}{\code{logical(1)}. When \code{TRUE}, the system field
\code{redcap_data_access_group} is included in the export.
This option is only
viable if the user whose token is being used to make the API request is
not in a data access group. If the user is in a group, then this
flag will revert to \code{FALSE}.}

\item{checkboxLabels}{\code{logical(1)}. When \code{FALSE} labels are
applied as "Unchecked"/"Checked".
When \code{TRUE}, they are applied as \verb{""/[field_label]} where \verb{[field_label]}
is the label assigned to the level in the data dictionary.}

\item{form_complete_auto}{\code{logical(1)}. When \code{TRUE}
(default), the \verb{[form]_complete} fields for any form
from which at least one variable is requested will automatically
be retrieved.  When \code{FALSE}, these fields must be
explicitly requested.}

\item{colClasses}{Named \code{character} vector. Column classes passed to
\code{\link[utils:read.table]{utils::read.csv()}} calls.
Useful to force the interpretation of a column in a specific type and
avoid an unexpected recast.}

\item{batch.size}{\code{integerish(1)}.  Specifies the number of subjects to be included
in each batch of a batched export or import.  Non-positive numbers
export/import the entire operation in a single batch.
Batching may be beneficial to prevent tying up smaller servers.
See Details.}

\item{dataFile}{\code{character(1)}. Gives the location
of the dataset downloaded from REDCap.  This should be the raw
(unlabeled) data set.}

\item{metaDataFile}{\code{character(1)}. Gives the location of the data dictionary
downloaded from REDCap.}

\item{...}{Arguments to pass to other methods}

\item{meta_data}{Deprecated version of \code{metaDataFile}.}
}
\value{
\code{exportRecords} returns a data frame with the project data. The
data will be formatted consistent with the meta data and the arguments
provided by the user.

\code{exportReports} returns a data frame with the data from the requested
report. The data will be formatted consisted with the meta data and
the arguments provided by the user.
}
\description{
These methods enable the user to export records and reports
from a project.
}
\details{
It is unnecessary to include `"redcap_event_name"`` in the fields argument.
This field is automatically exported for any longitudinal database.
If the user does include it in the fields argument, it is removed quietly
in the parameter checks.

There are four ways the data from checkbox variables may be
represented depending on the values of \code{factors} and
\code{checkboxLabels}. The most common are the first and third
rows of the table below.  When \code{checkboxLabels = TRUE}, either
the coded value or the labeled value is returned if the box is
checked, or an empty string if it is not.\tabular{lll}{
   \code{factors} \tab \code{checkboxLabels} \tab \code{Output} \cr
   \code{FALSE} \tab \code{FALSE} \tab 0 / 1 \cr
   \code{FALSE} \tab \code{TRUE} \tab "" / code \cr
   \code{TRUE} \tab \code{FALSE} \tab Unchecked / Checked \cr
   \code{TRUE} \tab \code{TRUE} \tab "" / label \cr
}


The 'offline' version of \code{exportReports} operates on the raw (unlabeled) data
file downloaded from REDCap along with the data dictionary.
This is made available for instances where the API cannot be accessed for
some reason (such as waiting for API approval from the REDCap administrator).

A 'batched' export (or import) is one where the export is performed over a series of
API calls rather than one large call.  For large projects on small servers,
this may prevent a single user from tying up the server and forcing others
to wait on a larger job.  The batched export is performed by first
calling the API to export the record identifier field (the first field
in the meta data).  The unique ID's are then assigned a batch number with
no more than \code{batch.size} ID's in any single batch.  The batches are
exported from the API and stacked together.

In longitudinal projects, \code{batch.size} may not necessarily be the
number of records exported in each batch.  If \code{batch.size} is ten and
there are four records per patient, each batch will consist of 40 records.
Thus, if the user is concerned about tying up the server with a large,
longitudinal project, it would be prudent to use a smaller batch size.
}
\section{Functions}{
\itemize{
\item \code{exportRecords()}: Export records from a project.

\item \code{exportRecords_offline()}: Format records from REDCap data file exports.

\item \code{exportReports()}: Export data via a report.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export records
exportRecords(rcon)

# Export records in batches of one hundred IDs
exportRecords(rcon, 
              batch.size = 100)
              
# Export records without factors
exportRecords(rcon, 
              factors = FALSE)
              

# Export a report
exportReports(rcon, 
              report_id = 12345)
              
# Export raw data
exportRecordsTyped(rcon, 
                   validation = skip_validation,
                   cast = raw_cast)

}


}
\seealso{
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportReportsTyped]{exportReportsTyped()}}, \cr
\code{\link[=importRecords]{importRecords()}}, \cr
\code{\link[=deleteRecords]{deleteRecords()}}, \cr
\code{\link[=exportNextRecordName]{exportNextRecordName()}}, \cr
\code{\link[=renameRecord]{renameRecord()}}
}
