% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFileToRecord.R
\name{importFileToRecord}
\alias{importFileToRecord}
\title{Import a File With Option to Create A Record to Receive the File}
\usage{
importFileToRecord(
  rcon,
  file,
  record = NULL,
  field,
  event,
  overwrite = TRUE,
  repeat_instance = NULL,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{file}{\code{character(1)}. The file path to the file to be imported.}

\item{record}{\code{character(1)} or \code{integerish(1)} or \code{NULL}. The record ID in
which the desired file is stored. When \code{NULL}, an attempt will be made to
create a new record for the file.  See 'Details'}

\item{field}{\code{character(1)}. The field name in which the file is stored.}

\item{event}{\code{character(1)} or \code{NULL}. The event name for the file.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message}

\item{overwrite}{\code{logical(1)}.  When \code{FALSE}, the function checks
if a file already exists for that record.  If a file exists, the function
terminates to prevent overwriting.  When \code{TRUE}, no additional
check is performed.}

\item{repeat_instance}{\code{integerish(1)} or \code{NULL}. The repeat instance number of
the repeating event or the repeating instrument. When available in your
instance of REDCap, and passed as \code{NULL}, the API will assume a value of 1.}

\item{...}{Arguments to pass to other methods}
}
\description{
There are times when the user may desire to create a record
and import a file as part of a single action. For example, a study
consent form may have been collected and needs to be stored with the
data of the new study participant. \code{importFileToRecord} extends
\code{importFiles} to allow the concurrent creation of the record in which
the file will be stored.
}
\details{
The behavior of \code{importFileToRecord} depends on
\enumerate{
\item whether record auto numbering has been enabled in the project,
\item if the record is specified by the user
\item if the record specified by the user exists.
}

The following table details the actions taken based on these conditions.
(\code{force_auto_number} is an argument to \code{\link[=importRecords]{importRecords()}}).\tabular{llll}{
   Autonumbering enabled \tab \code{record} \tab Record Exists \tab Action \cr
   Yes \tab \code{NULL} \tab No \tab Create a new record (using \code{force_auto_number = TRUE}) and import the file to the new record \cr
   Yes \tab Specified \tab Yes \tab Import the file to the existing record \cr
   Yes \tab Specified \tab No \tab Create a new record (using \code{force_auto_number = TRUE})and import the file to the new record \cr
   No \tab \code{NULL} \tab No \tab Error: record must be provided when auto numbering is not enabled \cr
   No \tab Specified \tab Yes \tab Import the file to the existing record \cr
   No \tab Specified \tab No \tab Create the record (using \code{force_auto_number = FALSE}) and import the file to the new record. \cr
}
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

importFileToRecord(rcon,
                   file = "file_to_upload.txt" 
                   record = NULL, 
                   field = "file_upload_test")
}
  
}
\seealso{
\code{\link[=importFiles]{importFiles()}},\cr
\code{\link[=importRecords]{importRecords()}}
}
