#' @name exportInstruments
#' @aliases exportInstruments.redcapApiConnection
#' @aliases exportInstruments.redcapDbConnection
#' @export exportInstruments
#' @export exportInstruments.redcapApiConnection
#' @export exportInstruments.redcapDbConnection
#' @importFrom httr POST
#' 
#' @title Export Instrument names
#' @description Retrieve a data frame giving the instrument names and labels in a project.
#' 
#' @param rcon A REDCap connection object as generated by \code{redcapConnection}
#' @param ... Arguments to be passed to other methods
#' 
#' @details This function allows you to export a list of the data collection 
#' instruments for a project. This includes their unique instrument name as 
#' seen in the second column of the Data Dictionary, as well as each 
#' instrument's corresponding instrument label, which is seen on a project's 
#' left-hand menu when entering data. The instruments will be ordered 
#' according to their order in the project.
#' 
#' This function was introduced to the API in version 5.9.  An error will be 
#' returned if called to an instance earlier than 5.9.  
#' 
#' @author Benjamin Nutter
#' 
#' @references
#' Please refer to your institution's API documentation.
#' 
#' Additional details on API parameters are found on the package wiki at
#' \url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
#' 

exportInstruments <- function(rcon, ...) UseMethod("exportInstruments")

#' @rdname exportInstruments

exportInstruments.redcapDbConnection <- function(rcon, ...){
  message("Please accept my apologies.  The exportInstruments method for redcapDbConnection objects\n",
          "has not yet been written.  Please consider using the API.")
}

#' @rdname exportInstruments

exportInstruments.redcapApiConnection <- function(rcon, ...){
  x <- httr::POST(url=rcon$url, 
                  body=list(token=rcon$token, content='instrument', format='csv'),
                  config=rcon$config)
  if (x$status_code == "200")
    read.csv(textConnection(as.character(x)), stringsAsFactors=FALSE) 
  else if (x$status_code == "400" & as.character(x) == "The value of the parameter \"content\" is not valid") 
    paste0(x$status_code, ": ", as.character(x))
  else stop(paste0(x$status_code, ": ", as.character(x)))
}
