\name{importFiles}
\alias{importFiles}
\alias{importFiles.redcapDbConnection}
\alias{importFiles.redcapApiConnection}
\title{Imports a File to Attach to a Record}
\description{A single file may be attached to a single record.  The behavior of this function is consistent with the
    behavior of the API, which only allows one file to be uploaded at a time.}

\usage{
\method{importFiles}{redcapDbConnection}(rcon, file, record, field, event, overwrite=TRUE, ...,
    proj=NULL)
\method{importFiles}{redcapApiConnection}(rcon, file, record, field, event, overwrite=TRUE, ...,
    proj=NULL)
}


\arguments{
  \item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}
  \item{file}{Character string giving the file path to the file to be imported.}
  \item{record}{The record ID in which the desired file is stored. Must be length 1.}
  \item{field}{The field name in which the file is stored. Must be length 1.}
  \item{event}{The event name for the file.  Must be length 1.  This applies only to longitudinal projects.  
    If the event is not
    supplied for a longitudinal project, the API will return an error}
  \item{overwrite}{Logical.  When \code{FALSE}, the function checks if a file already exists for that record.  
    If a file exists,
    the function terminates to prevent overwriting.  When \code{TRUE}, no additional check is performed.}
  \item{proj}{A \code{redcapProject} object as created by \code{redcapProjectInfo}.} 
  \item{...}{Arguments to be passed to other methods}
}

\details{
The function may only import a single file.}

\author{Benjamin Nutter}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterbAPI/redcap/wiki/REDCap-API-Parameters}
}

\examples{
\dontrun{
> #*** Note: I cannot provide working examples without
> #*** compromising security.  Instead, I will try to 
> #*** offer up sample code with the matching results
> 
> #*** Create the connection object
> rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
> 
>
> #* Import a single file
> importFiles(rcon, "Image.jpg", record=1, field="file_upload", event="event_1_arm_1")
The file was successfully uploaded
>
}
}

\keyword{ methods }
