% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degrade.R
\name{degrade}
\alias{degrade}
\title{Degradation of an image}
\usage{
degrade(z, L = 1, s = cbind(0, 0), noise = 0, blur = 1, L1 = L,
  L2 = L)
}
\arguments{
\item{z}{a \code{cimg}object containing the high resolution image}

\item{L}{numeric indicating the overall scale change. This parameter will be
override by L1 or L2}

\item{s}{numeric \code{p} by \code{2} matrix containing the registration
parameters}

\item{noise}{numeric indicating the standard deviation of the noise or an
\code{cimg}object that will be added to the resampled z}

\item{blur}{numeric indicating the blur range (for uniform blur) or an cimg
object with the blur kernel to be convolved with z if nothing is provided
an default kernel will be used.}

\item{L1}{numeric indicating the directional scale change}

\item{L2}{numeric indicating the directional scale change}
}
\value{
A degraded \code{cimg}object
}
\description{
This function degrades a high resolution image into a low resolution image.
}
\examples{
degraded.lenna <- degrade(lenna, L = 4, noise = 0.05, blur = 3)
par(mfrow = c(1,2), mar = c(0,0,1,0)+0.1)
plot(lenna, axes = FALSE, interp = FALSE, main = 'Original Lenna')
plot(degraded.lenna, axes = FALSE, interp = FALSE, main = 'Degraded Lenna')
}
