% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recogito.R
\name{recogito-shiny}
\alias{recogito-shiny}
\alias{recogitoOutput}
\alias{renderRecogito}
\alias{recogitotagsonlyOutput}
\alias{renderRecogitotagsonly}
\title{Shiny bindings for recogito}
\usage{
recogitoOutput(outputId, width = "100\%", height = "400px")

renderRecogito(expr, env = parent.frame(), quoted = FALSE)

recogitotagsonlyOutput(outputId, width = "100\%", height = "400px")

renderRecogitotagsonly(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a recogito}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output element for use in a Shiny user interface.\cr
Consisting of a div of class plaintext which contains an optional toggle button to switch
between annotation / relation mode (id: \code{outputId}\code{-toggle}) and
the html-widget (id: \code{outputId})
}
\description{
Output and render functions for using recogito within Shiny
applications and interactive Rmd documents.
}
\examples{
if(interactive() && require(shiny)){

##
## Tagging only, no relations
##
library(shiny)
library(recogito)
txt <- "Josh went to the bakery in Brussels.\nWhat an adventure!"
ui <- fluidPage(tags$h3("Provide some text to annotate"),
                textAreaInput(inputId = "ui_text", label = "Provide some text", value = txt),
                tags$h3("Annotation area"),
                recogitotagsonlyOutput(outputId = "annotation_text"),
                tags$hr(),
                tags$h3("Results"),
                verbatimTextOutput(outputId = "annotation_result"))
server <- function(input, output) {
  output$annotation_text <- renderRecogitotagsonly({
    recogito("annotations", text = input$ui_text, tags = c("LOCATION", "TIME", "PERSON"))
  })
  output$annotation_result <- renderPrint({
    read_recogito(input$annotations)
  })
}
shinyApp(ui, server)

##
## Tagging and relations
##
library(shiny)
library(recogito)
txt <- "Josh went to the bakery in Brussels.\nWhat an adventure!"
ui <- fluidPage(tags$h3("Provide some text to annotate"),
                textAreaInput(inputId = "ui_text", label = "Provide some text", value = txt),
                tags$h3("Annotation area"),
                recogitoOutput(outputId = "annotation_text"),
                tags$hr(),
                tags$h3("Results"),
                verbatimTextOutput(outputId = "annotation_result"))
server <- function(input, output) {
  output$annotation_text <- renderRecogito({
    recogito("annotations", text = input$ui_text, tags = c("LOCATION", "TIME", "PERSON"))
  })
  output$annotation_result <- renderPrint({
    read_recogito(input$annotations)
  })
}
shinyApp(ui, server)

}

recogitoOutput(outputId = "annotation_text")
recogitotagsonlyOutput(outputId = "annotation_text")
}
