% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recogito.R
\name{read_recogito}
\alias{read_recogito}
\title{Parse recogito annotations}
\usage{
read_recogito(x, text = character())
}
\arguments{
\item{x}{a character string with json as returned by the htmlwidget}

\item{text}{a character string with the text which was used in \code{x}}
}
\value{
a data.frame with annotations with columns: id, type, label, chunk_text, chunk_start, chunk_end, relation_from, relation_to, chunk_comment
and an attribute \code{text} with the provided \code{text}
}
\description{
Parse recogito annotations
}
\examples{
x <- '[
{
"type":"Annotation",
"body":[
   {"type":"TextualBody","value":"sdfsd","purpose":"commenting"},
   {"type":"TextualBody","value":"Person","purpose":"tagging"}],
"target":{"selector":[
  {"type":"TextQuoteSelector","exact":"ngenious hero"},
  {"type":"TextPositionSelector","start":42,"end":55}]},
"@context":"http://www.w3.org/ns/anno.jsonld",
"id":"#a4ea53d4-69f3-4392-a3dd-cbb7e9ad50cb"
},
{
"type":"Annotation",
"body":[{"type":"TextualBody","value":"Person","purpose":"tagging"},
  {"type":"TextualBody","value":"Location","purpose":"tagging"}],
"target":{"selector":[{"type":"TextQuoteSelector","exact":"far and"},
  {"type":"TextPositionSelector","start":70,"end":77}]},
"@context":"http://www.w3.org/ns/anno.jsonld",
"id":"#d7050196-2537-42bf-9d1b-a3f9e4c9fbc6"
}
]'
read_recogito(x)
}
