% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link}
\alias{link}
\title{Use the selected pairs to generate a linked data set}
\usage{
link(
  pairs,
  selection = NULL,
  all = FALSE,
  all_x = all,
  all_y = all,
  x = attr(pairs, "x"),
  y = attr(pairs, "y"),
  suffixes = c(".x", ".y"),
  keep_from_pairs = c(".x", ".y")
)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{selection}{a logical variable with the same length as \code{pairs} has
rows, or the name of such a variable in \code{pairs}. Pairs are only 
selected when \code{select} is \code{TRUE}. When missing 
\code{attr(pairs, "selection")} is used when available.}

\item{all}{return all records from \code{x} and \code{y}; even those that 
don't match.}

\item{all_x}{return all records from \code{x}.}

\item{all_y}{return all records from \code{y}.}

\item{x}{the first data set; when missing \code{attr(pairs, "x")} is used.}

\item{y}{the second data set; when missing \code{attr(pairs, "y")} is used.}

\item{suffixes}{a character vector of length 2 specifying the suffixes to be
used for making unique the names of columns in the result.}

\item{keep_from_pairs}{character vector with names of variables in \code{pairs}
that should be included in the output.}
}
\value{
Returns a \code{data.table} containing records from \code{x} and \code{y} and
\code{pairs}. Columns that occur both in \code{x} and \code{y} gain a suffix
indicating from which data set they are.
}
\description{
Use the selected pairs to generate a linked data set
}
\details{
Uses the selected pairs to link the two data sets to each other. Renames 
variables that are in both data sets.
}
