% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{step_scale}
\alias{step_scale}
\title{Scaling numeric data}
\usage{
step_scale(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  sds = NULL,
  factor = 1,
  na_rm = TRUE,
  skip = FALSE,
  id = rand_id("scale")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{sds}{A named numeric vector of standard deviations. This is \code{NULL}
until computed by \code{\link[=prep]{prep()}}.}

\item{factor}{A numeric value of either 1 or 2 that scales the numeric inputs
by one or two standard deviations. By dividing by two standard deviations,
the coefficients attached to continuous predictors can be interpreted the
same way as with binary inputs. Defaults to \code{1}. More in reference below.}

\item{na_rm}{A logical value indicating whether \code{NA} values should be removed
when computing the standard deviation.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_scale()} creates a \emph{specification} of a recipe step that will normalize
numeric data to have a standard deviation of one.
}
\details{
Scaling data means that the standard deviation of a variable is divided out
of the data. \code{step_scale()} estimates the variable standard deviations from
the data used in the \code{training} argument of \code{\link[=prep]{prep()}}. \code{\link[=bake]{bake()}} then applies
the scaling to new data sets using these standard deviations.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{numeric, the standard deviations}
\item{id}{character, id of this step}
}
}

\section{Sparse data}{


This step can be applied to \link{sparse_data} such that it is preserved. Nothing
needs to be done for this to happen as it is done automatically.
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
)

scaled_trans <- rec \%>\%
  step_scale(carbon, hydrogen)

scaled_obj <- prep(scaled_trans, training = biomass_tr)

transformed_te <- bake(scaled_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
tidy(scaled_trans, number = 1)
tidy(scaled_obj, number = 1)
\dontshow{\}) # examplesIf}
}
\references{
Gelman, A. (2007) "Scaling regression inputs by
dividing by two standard deviations." Unpublished. Source:
\verb{https://sites.stat.columbia.edu/gelman/research/unpublished/standardizing.pdf}.
}
\seealso{
Other normalization steps: 
\code{\link{step_center}()},
\code{\link{step_normalize}()},
\code{\link{step_range}()}
}
\concept{normalization steps}
