% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{step_sample}
\alias{step_sample}
\alias{tidy.step_sample}
\title{Sample rows using dplyr}
\usage{
step_sample(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  size = NULL,
  replace = FALSE,
  skip = TRUE,
  id = rand_id("sample")
)

\method{tidy}{step_sample}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{Argument ignored; included for consistency with other step
specification functions. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{size}{An integer or fraction. If the value is within (0, 1),
\code{\link[dplyr:sample_n]{dplyr::sample_frac()}} is applied to the data. If an integer
value of 1 or greater is used, \code{\link[dplyr:sample_n]{dplyr::sample_n()}} is applied.
The default of \code{NULL} uses \code{\link[dplyr:sample_n]{dplyr::sample_n()}} with the size
of the training set (or smaller for smaller \code{new_data}).}

\item{replace}{Sample with or without replacement?}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}; in most instances that
affect the rows of the data being predicted, this step probably should not
be applied.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_sample} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{size}, \code{replace},
and \code{id}.
}
\description{
\code{step_sample} creates a \emph{specification} of a recipe step
that will sample rows using \code{\link[dplyr:sample_n]{dplyr::sample_n()}} or
\code{\link[dplyr:sample_n]{dplyr::sample_frac()}}.
}
\examples{

# Uses `sample_n`
recipe( ~ ., data = iris) \%>\%
  step_sample(size = 1) \%>\%
  prep(training = iris) \%>\%
  juice() \%>\%
  nrow()

# Uses `sample_frac`
recipe( ~ ., data = iris) \%>\%
  step_sample(size = 0.9999) \%>\%
  prep(training = iris) \%>\%
  juice() \%>\%
  nrow()

# Uses `sample_n` and returns _at maximum_ 120 samples.
smaller_iris <-
  recipe( ~ ., data = iris) \%>\%
  step_sample() \%>\%
  prep(training = iris \%>\% slice(1:120))

juice(smaller_iris) \%>\% nrow()
bake(smaller_iris, iris \%>\% slice(121:150)) \%>\% nrow()
}
\concept{preprocessing}
\keyword{datagen}
