% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdraws_rpvals.R
\name{rPetersen}
\alias{rPetersen}
\title{Random Draws from the Petersen Estimator}
\usage{
rPetersen(length, N, n1 = NULL, n2 = NULL, p1 = NULL, p2 = NULL)
}
\arguments{
\item{length}{The length of the random vector to return.}

\item{N}{The value of the true abundance. This may be a single number or
vector of values equal to \code{length}.}

\item{n1}{Number of individuals captured and marked in the first sample. This
may be a single number or vector of values equal to \code{length}.}

\item{n2}{Number of individuals captured in the second sample.  This may be a
single number or vector of values equal to \code{length}.}

\item{p1}{Alternately, probability of capture in the first sample. This
may be a single number or vector of values equal to \code{length}.}

\item{p2}{Alternately, probability of capture in the second sample.  This may be a
single number or vector of values equal to \code{length}.}
}
\value{
A vector of random draws from the Petersen estimator
}
\description{
Returns a vector of random draws from the Petersen estimator in a
  mark-recapture experiment, given values of the true abundance and the
  sample size in both events.  The function first simulates a vector of
  recaptures (m2) from a hypergeometric distribution, and then uses these to
  compute a vector of draws from the estimator.

If capture probabilities (\code{p1} and/or \code{p2}) are specified instead of sample size(s), the sample size(s) will first be drawn from a binomial distribution, then the number of recaptures.  If both sample size and capture probability are specified for a given sampling event, only the sample size will be used.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
draws <- rPetersen(length=100000, N=500, n1=100, n2=100)
plotdiscdensity(draws)  #plots the density of a vector of discrete values
}
\seealso{
\link{NPetersen}, \link{vPetersen}, \link{sePetersen}, \link{pPetersen},
  \link{powPetersen}, \link{ciPetersen}
}
\author{
Matt Tyers
}
